﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.DataModel;
using Microsoft.Xrm.Sdk.Query;
using Microsoft.Xrm.Sdk;
using VA.TMP.OptionSets;
using MCSShared;

namespace VA.TMP.CRM
{
    class ParticipatingSiteUpdatePostStageRunner : PluginRunner
    {
        public ParticipatingSiteUpdatePostStageRunner(IServiceProvider serviceProvider) : base(serviceProvider) { }

        public override void Execute()
        {
            Logger.WriteDebugMessage("Starting Execute");
            var participatingSite = PrimaryEntity.ToEntity<cvt_participatingsite>();
            //throw new NotImplementedException();
            // get pr/post images to compare
            cvt_participatingsite psPre = PluginExecutionContext.PreEntityImages["PreImage"]?.ToEntity<cvt_participatingsite>();
            cvt_participatingsite psPost = PluginExecutionContext.PostEntityImages["PostImage"]?.ToEntity<cvt_participatingsite>();
            //Logger.WriteDebugMessage("Got Images.");

            #region COMPARE 'Schedulable' property
            // if the 'schedulable' field has changed, we want to call the "EntryFromParticipatingSite" Entry Point for Service Generation
            bool preSchedulable = false;
            bool postSchedulable = false;
            bool changedSchedulable = false;

            if (psPre.Attributes.Contains("cvt_scheduleable"))
            {
                var accessor = psPre["cvt_scheduleable"];
                preSchedulable = (accessor.ToString() == "True") ? true : false;
            }
            //Logger.WriteDebugMessage("Step 1");
            if (psPost.Attributes.Contains("cvt_scheduleable"))
            {
                var accessor = psPost["cvt_scheduleable"];
                postSchedulable = (accessor.ToString() == "True") ? true : false;
            }
            //Logger.WriteDebugMessage("Step 2");
            if (preSchedulable != postSchedulable)
            {
                changedSchedulable = true;
            }
            //Logger.WriteDebugMessage("Finished checking for change to scheduleable.");
            #endregion

            #region Compare Pre/Post State
            // if the record status has changed, we want to call the "EntryFromParticipatingSite" Entry Point for Service Generation
            int preState = (int)psPre.statuscode.Value;
            int postState = (int)psPost.statuscode.Value;
            bool changedStatus = false;

            if (preState != postState)
            {
                changedStatus = true;
            }
            //Logger.WriteDebugMessage("Finished checking for change to State.");
            #endregion

            #region Call Service Generation Entry Point

            if (changedSchedulable || changedStatus)
            {
                Logger.WriteDebugMessage("Change to Scheduleable or State detected.");
                CvtHelper.EntryFromParticipatingSite(participatingSite, Logger, OrganizationService);
            }
            else
                Logger.WriteDebugMessage("Change to Scheduleable or State not detected.");
            #endregion
        }

        public override string McsSettingsDebugField
        {
            get { return "cvt_participatingsiteplugin"; }
        }

    }
}
